/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.org.apache.commons.pool2.impl;

import club.sk1er.org.apache.commons.pool2.impl.CallStack;
import club.sk1er.org.apache.commons.pool2.impl.SecurityManagerCallStack;
import club.sk1er.org.apache.commons.pool2.impl.ThrowableCallStack;
import java.security.AccessControlException;

public final class CallStackUtils {
    private static boolean canCreateSecurityManager() {
        SecurityManager manager = System.getSecurityManager();
        if (manager == null) {
            return true;
        }
        try {
            manager.checkPermission(new RuntimePermission("createSecurityManager"));
            return true;
        }
        catch (AccessControlException ignored) {
            return false;
        }
    }

    @Deprecated
    public static CallStack newCallStack(String messageFormat, boolean useTimestamp) {
        return CallStackUtils.newCallStack(messageFormat, useTimestamp, false);
    }

    public static CallStack newCallStack(String messageFormat, boolean useTimestamp, boolean requireFullStackTrace) {
        return CallStackUtils.canCreateSecurityManager() && !requireFullStackTrace ? new SecurityManagerCallStack(messageFormat, useTimestamp) : new ThrowableCallStack(messageFormat, useTimestamp);
    }

    private CallStackUtils() {
    }
}

